*** Table 1: Summary Statistics

cd "$path"
global data "$path/data/"
global output "$path/results"

estimates clear 

// County - level 
use  "$data/main_county_FD.dta", clear

global level fr_black_40 cong_dem_40 cong_turnout_40 
global change D_fr_black D_cong_dem D_cong_turnout 



eststo: estpost tabstat $level [aw=totpop_40] if year==1940, ///
		statistics(mean p50 sd min max count ) columns(statistics)  
esttab . using "$output/Table1_county.csv", cells("mean(fmt(3)) p50(fmt(3)) sd(fmt(3)) min(fmt(3)) max(fmt(3)) count ")   ///
		nostar unstack noobs nonote replace 
		
		
		
eststo: estpost tabstat $change [aw=totpop_40], ///
		statistics(mean p50 sd min max count ) columns(statistics)  
esttab . using "$output/Table1_county.csv", cells("mean(fmt(3)) p50(fmt(3)) sd(fmt(3)) min(fmt(3)) max(fmt(3)) count ")   ///
		nostar unstack noobs nonote append 
		
		
		
// CD - level 

use  "$data/main_CD.dta", clear

global var78 fr_b40n_p78  wp_civilrightsagn_78
global varchange D_fr_bl_p78 D_civilrightsagn

eststo: estpost tabstat $var78 [aw=pop_cd78] if year==1940, ///
		statistics(mean p50 sd min max count ) columns(statistics)  
esttab . using "$output/Table1_cd.csv", cells("mean(fmt(3)) p50(fmt(3)) sd(fmt(3)) min(fmt(3)) max(fmt(3)) count ")   ///
		nostar unstack noobs nonote replace 
		
eststo: estpost tabstat $varchange [aw=pop_cd78], ///
		statistics(mean p50 sd min max count ) columns(statistics)  
esttab . using "$output/Table1_cd.csv", cells("mean(fmt(3)) p50(fmt(3)) sd(fmt(3)) min(fmt(3)) max(fmt(3)) count ")   ///
		nostar unstack noobs nonote append 
		
		
		
		